<?php 
namespace VanguardLTE\Games\StarBurstNET
{
    set_time_limit(5);
    class Server
    {
        public function get($request, $game)
        {
            function get_($request, $game)
            {
            \DB::transaction(function() use ($request, $game)
            {
                try
                {
                    $userId = \Auth::id();
                    if( $userId == null ) 
                    {
                        $response = '{"responseEvent":"error","responseType":"","serverResponse":"invalid login"}';
                        exit( $response );
                    }
                        $slotSettings = new SlotSettings($game, $userId);
                        if( !$slotSettings->is_active() ) 
                        {
                            $response = '{"responseEvent":"error","responseType":"","serverResponse":"Game is disabled"}';
                            exit( $response );
                        }
                    $postData = $_GET;
                    $balanceInCents = round($slotSettings->GetBalance() * $slotSettings->CurrentDenom * 100);
                    $result_tmp = [];
                    $aid = '';
                    $postData['slotEvent'] = 'bet';
                    if( $postData['action'] == 'respin' ) 
                    {
                        $postData['slotEvent'] = 'freespin';
                        $postData['action'] = 'spin';
                    }
                    if( $postData['action'] == 'init' || $postData['action'] == 'reloadbalance' ) 
                    {
                        $postData['action'] = 'init';
                        $postData['slotEvent'] = 'init';
                    }
                    if( $postData['action'] == 'paytable' ) 
                    {
                        $postData['slotEvent'] = 'paytable';
                    }
                    if( $postData['action'] == 'initfreespin' ) 
                    {
                        $postData['slotEvent'] = 'initfreespin';
                    }
                    if( isset($postData['bet_denomination']) && $postData['bet_denomination'] >= 1 ) 
                    {
                        $postData['bet_denomination'] = $postData['bet_denomination'] / 100;
                        $slotSettings->CurrentDenom = $postData['bet_denomination'];
                        $slotSettings->CurrentDenomination = $postData['bet_denomination'];
                        $slotSettings->SetGameData($slotSettings->slotId . 'GameDenom', $postData['bet_denomination']);
                    }
                    else if( $slotSettings->HasGameData($slotSettings->slotId . 'GameDenom') ) 
                    {
                        $postData['bet_denomination'] = $slotSettings->GetGameData($slotSettings->slotId . 'GameDenom');
                        $slotSettings->CurrentDenom = $postData['bet_denomination'];
                        $slotSettings->CurrentDenomination = $postData['bet_denomination'];
                    }
                    $balanceInCents = round($slotSettings->GetBalance() * $slotSettings->CurrentDenom * 100);
                    if( $postData['slotEvent'] == 'bet' ) 
                    {
                        $lines = 10;
                        $betline = $postData['bet_betlevel'];
                        if( $lines <= 0 || $betline <= 0.0001 ) 
                        {
                            $response = '{"responseEvent":"error","responseType":"' . $postData['slotEvent'] . '","serverResponse":"invalid bet state"}';
                            exit( $response );
                        }
                        if( $slotSettings->GetBalance() < ($lines * $betline) ) 
                        {
                            $response = '{"responseEvent":"error","responseType":"' . $postData['slotEvent'] . '","serverResponse":"invalid balance"}';
                            exit( $response );
                        }
                    }
                    if( $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') < $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame') && $postData['slotEvent'] == 'freespin' ) 
                    {
                        $response = '{"responseEvent":"error","responseType":"' . $postData['slotEvent'] . '","serverResponse":"invalid bonus state"}';
                        exit( $response );
                    }
                    $aid = (string)$postData['action'];
                    switch( $aid ) 
                    {
                        case 'init':
                            $gameBets = $slotSettings->Bet;
                            $lastEvent = $slotSettings->GetHistory();
                            $slotSettings->SetGameData('StarBurstNETBonusWin', 0);
                            $slotSettings->SetGameData('StarBurstNETFreeGames', 0);
                            $slotSettings->SetGameData('StarBurstNETCurrentFreeGame', 0);
                            $slotSettings->SetGameData('StarBurstNETTotalWin', 0);
                            $slotSettings->SetGameData('StarBurstNETFreeBalance', 0);
                            $freeState = '';
                            if( $lastEvent != 'NULL' ) 
                            {
                                $slotSettings->SetGameData($slotSettings->slotId . 'BonusWin', $lastEvent->serverResponse->bonusWin);
                                $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', $lastEvent->serverResponse->totalFreeGames);
                                $slotSettings->SetGameData($slotSettings->slotId . 'CurrentFreeGame', $lastEvent->serverResponse->currentFreeGames);
                                $slotSettings->SetGameData($slotSettings->slotId . 'TotalWin', $lastEvent->serverResponse->bonusWin);
                                $slotSettings->SetGameData($slotSettings->slotId . 'FreeBalance', $lastEvent->serverResponse->Balance);
                                $freeState = $lastEvent->serverResponse->freeState;
                                $reels = $lastEvent->serverResponse->reelsSymbols;
                                $curReels = '&rs.i0.r.i0.syms=SYM' . $reels->reel1[0] . '%2CSYM' . $reels->reel1[1] . '%2CSYM' . $reels->reel1[2] . '';
                                $curReels .= ('&rs.i0.r.i1.syms=SYM' . $reels->reel2[0] . '%2CSYM' . $reels->reel2[1] . '%2CSYM' . $reels->reel2[2] . '');
                                $curReels .= ('&rs.i0.r.i2.syms=SYM' . $reels->reel3[0] . '%2CSYM' . $reels->reel3[1] . '%2CSYM' . $reels->reel3[2] . '');
                                $curReels .= ('&rs.i0.r.i3.syms=SYM' . $reels->reel4[0] . '%2CSYM' . $reels->reel4[1] . '%2CSYM' . $reels->reel4[2] . '');
                                $curReels .= ('&rs.i0.r.i4.syms=SYM' . $reels->reel5[0] . '%2CSYM' . $reels->reel5[1] . '%2CSYM' . $reels->reel5[2] . '');
                                $curReels .= ('&rs.i1.r.i0.syms=SYM' . $reels->reel1[0] . '%2CSYM' . $reels->reel1[1] . '%2CSYM' . $reels->reel1[2] . '');
                                $curReels .= ('&rs.i1.r.i1.syms=SYM' . $reels->reel2[0] . '%2CSYM' . $reels->reel2[1] . '%2CSYM' . $reels->reel2[2] . '');
                                $curReels .= ('&rs.i1.r.i2.syms=SYM' . $reels->reel3[0] . '%2CSYM' . $reels->reel3[1] . '%2CSYM' . $reels->reel3[2] . '');
                                $curReels .= ('&rs.i1.r.i3.syms=SYM' . $reels->reel4[0] . '%2CSYM' . $reels->reel4[1] . '%2CSYM' . $reels->reel4[2] . '');
                                $curReels .= ('&rs.i1.r.i4.syms=SYM' . $reels->reel5[0] . '%2CSYM' . $reels->reel5[1] . '%2CSYM' . $reels->reel5[2] . '');
                                $curReels .= ('&rs.i0.r.i0.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i0.r.i1.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i0.r.i2.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i0.r.i3.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i0.r.i4.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i1.r.i0.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i1.r.i1.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i1.r.i2.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i1.r.i3.pos=' . $reels->rp[0]);
                                $curReels .= ('&rs.i1.r.i4.pos=' . $reels->rp[0]);
                            }
                            else
                            {
                                $curReels = '&rs.i0.r.i0.syms=SYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '';
                                $curReels .= ('&rs.i0.r.i1.syms=SYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '');
                                $curReels .= ('&rs.i0.r.i2.syms=SYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '');
                                $curReels .= ('&rs.i0.r.i3.syms=SYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '');
                                $curReels .= ('&rs.i0.r.i4.syms=SYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '%2CSYM' . rand(1, 7) . '');
                                $curReels .= ('&rs.i0.r.i0.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i0.r.i1.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i0.r.i2.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i0.r.i3.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i0.r.i4.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i1.r.i0.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i1.r.i1.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i1.r.i2.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i1.r.i3.pos=' . rand(1, 10));
                                $curReels .= ('&rs.i1.r.i4.pos=' . rand(1, 10));
                            }
                            for( $d = 0; $d < count($slotSettings->Denominations); $d++ ) 
                            {
                                $slotSettings->Denominations[$d] = $slotSettings->Denominations[$d] * 100;
                            }
                            $result_tmp[] = 'rs.i1.r.i0.syms=SYM9%2CSYM9%2CSYM9&bl.i6.coins=1&rs.i0.r.i4.hold=false&rs.i1.r.i2.hold=true&game.win.cents=0&rs.i7.r.i3.syms=SYM8%2CSYM8%2CSYM8&staticsharedurl=https%3A%2F%2Fstatic-shared.casinomodule.com%2Fgameclient_html%2Fdevicedetection%2Fcurrent&bl.i0.reelset=ALL&bl.i3.reelset=ALL&bl.i4.line=2%2C1%2C0%2C1%2C2&rs.i5.r.i3.strip=SYM1%2CSYM1%2CSYM1&rs.i2.r.i0.hold=false&rs.i0.r.i0.syms=SYM9%2CSYM9%2CSYM9&bl.i2.id=2&rs.i1.r.i1.pos=0&rs.i7.r.i1.syms=SYM5%2CSYM5%2CSYM5&rs.i3.r.i4.pos=0&rs.i6.r.i3.syms=SYM8%2CSYM8%2CSYM8&rs.i0.r.i0.pos=0&rs.i3.r.i1.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8&rs.i6.r.i3.strip=SYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM1%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7&rs.i2.r.i3.pos=0&rs.i5.r.i0.pos=0&rs.i7.id=basic&rs.i7.r.i3.pos=0&rs.i2.r.i4.hold=false&rs.i3.r.i1.pos=0&rs.i0.r.i3.strip=SYM1%2CSYM1%2CSYM1&rs.i2.id=wildOnReel_23&rs.i6.r.i1.pos=0&game.win.coins=0&rs.i1.r.i0.hold=false&rs.i4.r.i1.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8&bl.i3.id=3&bl.i8.reelset=ALL&clientaction=init&rs.i4.r.i0.hold=false&rs.i0.r.i2.hold=false&rs.i4.r.i3.syms=SYM1%2CSYM1%2CSYM1&casinoID=netent&bl.i5.coins=1&rs.i3.r.i2.hold=true&bl.i8.id=8&rs.i5.r.i1.syms=SYM1%2CSYM1%2CSYM1&rs.i7.r.i0.pos=0&rs.i0.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3&rs.i7.r.i3.hold=false&rs.i0.r.i3.pos=0&rs.i4.r.i0.syms=SYM9%2CSYM9%2CSYM9&rs.i4.r.i2.strip=SYM9%2CSYM9%2CSYM9%2CSYM1%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3&rs.i5.r.i3.pos=0&bl.i6.line=2%2C2%2C1%2C2%2C2&bl.i0.line=1%2C1%2C1%2C1%2C1&rs.i1.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3&rs.i4.r.i2.pos=0&rs.i0.r.i2.syms=SYM9%2CSYM9%2CSYM9&game.win.amount=0&rs.i5.r.i2.strip=SYM1%2CSYM1%2CSYM1&betlevel.all=1%2C2%2C3%2C4%2C5%2C6%2C7%2C8%2C9%2C10&rs.i5.r.i2.hold=true&rs.i5.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3&rs.i7.r.i3.strip=SYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM1%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM1%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM1%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9&denomination.all=' . implode('%2C', $slotSettings->Denominations) . '&rs.i2.r.i0.pos=0&current.rs.i0=basic&rs.i7.r.i2.pos=0&bl.i1.id=1&rs.i3.r.i2.syms=SYM1%2CSYM1%2CSYM1&rs.i2.r.i1.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8&rs.i4.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6&rs.i1.r.i4.pos=0&denomination.standard=' . ($slotSettings->CurrentDenomination * 100) . '&rs.i3.id=wildOnReel_2&multiplier=1&rs.i0.r.i2.strip=SYM9%2CSYM9%2CSYM9%2CSYM1%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3&bl.i2.coins=1&bl.i6.id=6&autoplay=10%2C25%2C50%2C75%2C100%2C250%2C500%2C750%2C1000&rs.i6.r.i2.pos=0&rs.i1.r.i4.syms=SYM9%2CSYM9%2CSYM9&gamesoundurl=&rs.i5.r.i2.syms=SYM1%2CSYM1%2CSYM1&rs.i5.r.i3.hold=true&rs.i4.r.i2.hold=false&bl.i5.reelset=ALL&rs.i4.r.i1.syms=SYM9%2CSYM9%2CSYM9&bl.i7.id=7&rs.i2.r.i4.pos=0&rs.i3.r.i0.syms=SYM9%2CSYM9%2CSYM9&playercurrencyiso=' . $slotSettings->slotCurrency . '&bl.i1.coins=1&rs.i4.r.i1.hold=false&rs.i3.r.i2.pos=0&playforfun=false&jackpotcurrencyiso=' . $slotSettings->slotCurrency . '&rs.i0.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7&rs.i0.r.i4.syms=SYM9%2CSYM9%2CSYM9&rs.i0.r.i2.pos=0&rs.i6.r.i3.pos=0&rs.i1.r.i0.pos=0&rs.i6.r.i3.hold=false&bl.i0.coins=1&rs.i2.r.i0.syms=SYM9%2CSYM9%2CSYM9&bl.i2.reelset=ALL&rs.i3.r.i1.syms=SYM9%2CSYM9%2CSYM9&rs.i1.r.i4.hold=false&rs.i4.r.i1.pos=0&rs.i4.r.i2.syms=SYM9%2CSYM9%2CSYM9&rs.i7.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8&bl.standard=0%2C1%2C2%2C3%2C4%2C5%2C6%2C7%2C8%2C9&rs.i5.r.i3.syms=SYM1%2CSYM1%2CSYM1&rs.i0.r.i1.strip=SYM1%2CSYM1%2CSYM1&rs.i3.r.i0.hold=false&rs.i6.r.i4.syms=SYM9%2CSYM9%2CSYM9&rs.i0.r.i3.hold=true&rs.i2.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7&rs.i5.r.i4.pos=0&rs.i4.id=wildOnReel_3&rs.i7.r.i2.syms=SYM9%2CSYM9%2CSYM9&rs.i2.r.i1.hold=false&g4mode=false&historybutton=false&bl.i5.id=5&gameEventSetters.enabled=false&next.rs=basic&rs.i1.r.i3.pos=0&rs.i0.r.i1.syms=SYM1%2CSYM1%2CSYM1&bl.i3.coins=1&rs.i2.r.i1.pos=0&rs.i7.r.i4.hold=false&rs.i4.r.i4.pos=0&rs.i1.r.i3.hold=false&rs.i7.r.i1.pos=0&totalwin.coins=0&rs.i5.r.i4.syms=SYM9%2CSYM9%2CSYM9&bl.i5.line=0%2C0%2C1%2C0%2C0&gamestate.current=basic&rs.i4.r.i0.pos=0&jackpotcurrency=%26%23x20AC%3B&bl.i7.line=1%2C2%2C2%2C2%2C1&rs.i3.r.i1.hold=false&rs.i3.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3&rs.i7.r.i4.syms=SYM9%2CSYM9%2CSYM9&rs.i0.r.i3.syms=SYM1%2CSYM1%2CSYM1&rs.i1.r.i1.syms=SYM1%2CSYM1%2CSYM1&rs.i5.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7&bl.i9.coins=1&bl.i7.reelset=ALL&isJackpotWin=false&rs.i4.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3&rs.i6.r.i4.hold=false&rs.i2.r.i3.hold=true&rs.i1.r.i2.strip=SYM1%2CSYM1%2CSYM1&rs.i6.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7&rs.i0.r.i1.pos=0&rs.i4.r.i4.syms=SYM9%2CSYM9%2CSYM9&rs.i1.r.i3.syms=SYM8%2CSYM8%2CSYM8&rs.i2.r.i2.strip=SYM1%2CSYM1%2CSYM1&rs.i0.r.i1.hold=true&rs.i2.r.i1.syms=SYM9%2CSYM9%2CSYM9&bl.i9.line=1%2C0%2C1%2C0%2C1&betlevel.standard=1&rs.i6.r.i2.syms=SYM9%2CSYM9%2CSYM9&rs.i7.r.i0.syms=SYM9%2CSYM9%2CSYM9&gameover=true&rs.i3.r.i3.pos=0&rs.i7.r.i2.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM1%2CSYM3%2CSYM3%2CSYM3%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM1%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM1%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6&rs.i5.id=wildOnReel_123&rs.i2.r.i3.strip=SYM1%2CSYM1%2CSYM1&rs.i7.r.i0.hold=false&rs.i6.r.i4.pos=0&rs.i6.r.i1.strip=SYM1%2CSYM1%2CSYM1&rs.i5.r.i1.hold=true&rs.i5.r.i4.hold=false&rs.i6.r.i2.hold=false&bl.i0.id=0&nextaction=spin&bl.i3.line=0%2C1%2C2%2C1%2C0&rs.i7.r.i1.strip=SYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM1%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM1%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM1%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8&bl.i4.reelset=ALL&bl.i4.coins=1&rs.i3.r.i3.strip=SYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7&bl.i9.id=9&rs.i4.r.i3.pos=0&playercurrency=%26%23x20AC%3B&bl.i9.reelset=ALL&rs.i4.r.i3.strip=SYM1%2CSYM1%2CSYM1&rs.i4.r.i4.hold=false&rs.i6.r.i2.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM1%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM3%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3&rs.i5.r.i0.syms=SYM9%2CSYM9%2CSYM9&rs.i2.r.i4.syms=SYM9%2CSYM9%2CSYM9&rs.i1.r.i3.strip=SYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM1%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM3%2CSYM3%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7&rs.i3.r.i2.strip=SYM1%2CSYM1%2CSYM1&rs.i5.r.i1.strip=SYM1%2CSYM1%2CSYM1&rs.i7.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4&rs.i7.r.i4.pos=0&rs.i4.r.i3.hold=true&rs.i2.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3&rs.i6.r.i0.hold=false&rs.i0.id=wildOnReel_13&credit=' . $balanceInCents . '&bl.i1.reelset=ALL&rs.i2.r.i2.pos=0&rs.i5.r.i1.pos=0&bl.i1.line=0%2C0%2C0%2C0%2C0&rs.i6.r.i0.syms=SYM9%2CSYM9%2CSYM9&rs.i6.r.i1.hold=true&rs.i2.r.i2.syms=SYM1%2CSYM1%2CSYM1&rs.i1.r.i2.pos=0&rs.i3.r.i3.syms=SYM8%2CSYM8%2CSYM8&rs.i3.r.i4.hold=false&rs.i5.r.i0.hold=false&nearwinallowed=true&bl.i8.line=1%2C0%2C0%2C0%2C1&rs.i7.r.i2.hold=false&rs.i1.r.i1.strip=SYM1%2CSYM1%2CSYM1&rs.i6.r.i1.syms=SYM1%2CSYM1%2CSYM1&rs.i3.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM5%2CSYM5%2CSYM5%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7&rs.i3.r.i3.hold=false&rs.i6.r.i0.pos=0&bl.i8.coins=1&bl.i2.line=2%2C2%2C2%2C2%2C2&rs.i1.r.i2.syms=SYM1%2CSYM1%2CSYM1&rs.i6.id=wildOnReel_1&rs.i6.r.i4.strip=SYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM4%2CSYM4%2CSYM4%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM3%2CSYM9%2CSYM9%2CSYM9%2CSYM4%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3%2CSYM4%2CSYM4%2CSYM4%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM3%2CSYM3&totalwin.cents=0&rs.i7.r.i1.hold=false&rs.i1.r.i0.strip=SYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM3%2CSYM3%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM8%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM3%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM7%2CSYM7%2CSYM7%2CSYM3%2CSYM3%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM8%2CSYM8%2CSYM8%2CSYM4%2CSYM4%2CSYM6%2CSYM6%2CSYM6%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM8%2CSYM8%2CSYM8%2CSYM6%2CSYM6%2CSYM7%2CSYM7%2CSYM7%2CSYM9%2CSYM9%2CSYM9%2CSYM5%2CSYM5%2CSYM5%2CSYM7%2CSYM7&rs.i5.r.i2.pos=0&rs.i0.r.i0.hold=false&rs.i2.r.i3.syms=SYM1%2CSYM1%2CSYM1&restore=false&rs.i1.id=wildOnReel_12&rs.i3.r.i4.syms=SYM9%2CSYM9%2CSYM9&bl.i4.id=4&rs.i0.r.i4.pos=0&bl.i7.coins=1&bl.i6.reelset=ALL&rs.i3.r.i0.pos=0&rs.i2.r.i2.hold=true&wavecount=1&rs.i1.r.i1.hold=true' . $curReels . $freeState;
                            break;
                        case 'paytable':
                            $result_tmp[] = 'pt.i0.comp.i0.type=betline&pt.i0.comp.i19.symbol=SYM9&bl.i6.coins=1&g4mode=false&pt.i0.comp.i15.type=betline&historybutton=false&pt.i0.comp.i16.symbol=SYM8&bl.i5.id=5&pt.i0.comp.i1.multi=200&pt.i0.comp.i4.multi=60&pt.i0.comp.i15.symbol=SYM8&pt.i0.comp.i17.symbol=SYM8&pt.i0.comp.i18.symbol=SYM9&pt.i0.comp.i5.freespins=0&pt.i0.comp.i12.multi=7&bl.i3.coins=1&pt.i0.comp.i11.symbol=SYM6&pt.i0.comp.i12.symbol=SYM7&pt.i0.comp.i13.symbol=SYM7&pt.i0.comp.i14.symbol=SYM7&pt.i0.comp.i15.multi=5&pt.i0.comp.i14.type=betline&bl.i0.reelset=ALL&pt.i0.comp.i16.freespins=0&pt.i0.comp.i18.multi=5&bl.i5.line=0%2C0%2C1%2C0%2C0&pt.i0.comp.i7.multi=25&pt.i0.comp.i11.n=5&pt.i0.comp.i4.freespins=0&bl.i3.reelset=ALL&pt.i0.comp.i9.n=3&bl.i4.line=2%2C1%2C0%2C1%2C2&jackpotcurrency=%26%23x20AC%3B&bl.i7.line=1%2C2%2C2%2C2%2C1&pt.i0.comp.i19.n=4&pt.i0.id=basic&pt.i0.comp.i10.symbol=SYM6&pt.i0.comp.i1.type=betline&pt.i0.comp.i15.n=3&bl.i2.id=2&bl.i9.coins=1&bl.i7.reelset=ALL&isJackpotWin=false&pt.i0.comp.i2.symbol=SYM3&pt.i0.comp.i4.symbol=SYM4&pt.i0.comp.i20.type=betline&pt.i0.comp.i17.freespins=0&pt.i0.comp.i6.symbol=SYM5&pt.i0.comp.i8.symbol=SYM5&pt.i0.comp.i0.symbol=SYM3&pt.i0.comp.i1.n=4&pt.i0.comp.i5.n=5&pt.i0.comp.i3.type=betline&pt.i0.comp.i3.freespins=0&pt.i0.comp.i10.multi=20&pt.i0.comp.i10.freespins=0&pt.i0.comp.i20.multi=25&pt.i0.comp.i20.n=5&pt.i0.comp.i17.multi=25&bl.i3.id=3&pt.i0.comp.i9.multi=8&pt.i0.comp.i9.type=betline&bl.i8.reelset=ALL&pt.i0.comp.i14.freespins=0&clientaction=paytable&bl.i9.line=1%2C0%2C1%2C0%2C1&pt.i0.comp.i2.multi=250&pt.i0.comp.i0.freespins=0&bl.i5.coins=1&bl.i8.id=8&pt.i0.comp.i16.multi=10&pt.i0.comp.i9.symbol=SYM6&pt.i0.comp.i16.n=4&pt.i0.comp.i12.n=3&bl.i0.id=0&bl.i6.line=2%2C2%2C1%2C2%2C2&pt.i0.comp.i13.type=betline&pt.i0.comp.i16.type=betline&bl.i0.line=1%2C1%2C1%2C1%2C1&pt.i0.comp.i5.symbol=SYM4&pt.i0.comp.i19.type=betline&bl.i3.line=0%2C1%2C2%2C1%2C0&pt.i0.comp.i6.freespins=0&bl.i4.reelset=ALL&bl.i4.coins=1&pt.i0.comp.i2.n=5&pt.i0.comp.i1.symbol=SYM3&pt.i0.comp.i3.multi=25&pt.i0.comp.i6.n=3&bl.i9.id=9&pt.i0.comp.i19.freespins=0&pt.i0.comp.i6.type=betline&playercurrency=%26%23x20AC%3B&bl.i9.reelset=ALL&bl.i1.id=1&pt.i0.comp.i10.type=betline&pt.i0.comp.i9.freespins=0&credit=497800&pt.i0.comp.i5.type=betline&pt.i0.comp.i11.freespins=0&pt.i0.comp.i2.freespins=0&pt.i0.comp.i5.multi=120&pt.i0.comp.i7.n=4&pt.i0.comp.i11.multi=50&bl.i1.reelset=ALL&pt.i0.comp.i7.type=betline&pt.i0.comp.i4.type=betline&pt.i0.comp.i13.freespins=0&pt.i0.comp.i17.n=5&bl.i2.coins=1&bl.i6.id=6&bl.i1.line=0%2C0%2C0%2C0%2C0&pt.i0.comp.i13.n=4&pt.i0.comp.i8.freespins=0&pt.i0.comp.i20.freespins=0&pt.i0.comp.i8.multi=60&gamesoundurl=&pt.i0.comp.i1.freespins=0&pt.i0.comp.i12.type=betline&pt.i0.comp.i14.multi=40&pt.i0.comp.i3.n=3&bl.i5.reelset=ALL&bl.i7.id=7&pt.i0.comp.i6.multi=10&bl.i8.line=1%2C0%2C0%2C0%2C1&playercurrencyiso=' . $slotSettings->slotCurrency . '&bl.i1.coins=1&pt.i0.comp.i18.type=betline&playforfun=false&jackpotcurrencyiso=' . $slotSettings->slotCurrency . '&pt.i0.comp.i8.type=betline&pt.i0.comp.i7.freespins=0&bl.i8.coins=1&pt.i0.comp.i2.type=betline&pt.i0.comp.i13.multi=15&bl.i2.line=2%2C2%2C2%2C2%2C2&pt.i0.comp.i17.type=betline&bl.i0.coins=1&bl.i2.reelset=ALL&pt.i0.comp.i8.n=5&pt.i0.comp.i10.n=4&pt.i0.comp.i18.freespins=0&pt.i0.comp.i11.type=betline&pt.i0.comp.i18.n=3&bl.i4.id=4&bl.i7.coins=1&pt.i0.comp.i14.n=5&pt.i0.comp.i0.multi=50&pt.i0.comp.i20.symbol=SYM9&pt.i0.comp.i15.freespins=0&bl.i6.reelset=ALL&pt.i0.comp.i19.multi=10&pt.i0.comp.i3.symbol=SYM4&pt.i0.comp.i0.n=3&pt.i0.comp.i7.symbol=SYM5&pt.i0.comp.i12.freespins=0&pt.i0.comp.i4.n=4';
                        case 'initfreespin':
                            $result_tmp[] = 'rs.i1.r.i0.syms=SYM5%2CSYM0%2CSYM6&freespins.betlevel=1&g4mode=false&freespins.win.coins=0&playercurrency=%26%23x20AC%3B&historybutton=false&rs.i0.r.i4.hold=false&gamestate.history=basic&rs.i1.r.i2.hold=false&rs.i1.r.i3.pos=18&rs.i0.r.i1.syms=SYM5%2CSYM5%2CSYM7&game.win.cents=0&rs.i0.id=freespin&rs.i1.r.i3.hold=false&totalwin.coins=0&credit=497520&rs.i1.r.i4.pos=30&gamestate.current=freespin&freespins.initial=15&jackpotcurrency=%26%23x20AC%3B&multiplier=1&bet.betlines=0%2C1%2C2%2C3%2C4%2C5%2C6%2C7%2C8%2C9%2C10%2C11%2C12%2C13%2C14%2C15%2C16%2C17%2C18%2C19&rs.i0.r.i0.syms=SYM2%2CSYM7%2CSYM7&freespins.denomination=2.000&rs.i0.r.i3.syms=SYM4%2CSYM4%2CSYM4&rs.i1.r.i1.syms=SYM2%2CSYM3%2CSYM3&rs.i1.r.i1.pos=3&freespins.win.cents=0&freespins.totalwin.coins=0&freespins.total=15&isJackpotWin=false&gamestate.stack=basic%2Cfreespin&rs.i0.r.i0.pos=3&rs.i1.r.i4.syms=SYM1%2CSYM7%2CSYM7&freespins.betlines=0%2C1%2C2%2C3%2C4%2C5%2C6%2C7%2C8%2C9%2C10%2C11%2C12%2C13%2C14%2C15%2C16%2C17%2C18%2C19&gamesoundurl=&rs.i1.r.i2.pos=15&bet.betlevel=1&rs.i1.nearwin=4%2C3&rs.i0.r.i1.pos=18&rs.i1.r.i3.syms=SYM4%2CSYM0%2CSYM6&game.win.coins=0&playercurrencyiso=' . $slotSettings->slotCurrency . '&rs.i1.r.i0.hold=false&rs.i0.r.i1.hold=false&freespins.wavecount=1&freespins.multiplier=1&playforfun=false&jackpotcurrencyiso=' . $slotSettings->slotCurrency . "&clientaction=initfreespin&rs.i0.r.i2.hold=false&rs.i0.r.i4.syms=SYM6%2CSYM5%2CSYM5&rs.i0.r.i2.pos=0&rs.i1.r.i2.syms=SYM6%2CSYM6%2CSYM0&rs.i1.r.i0.pos=24&totalwin.cents=0&gameover=false&rs.i0.r.i0.hold=false&rs.i1.id=basic&rs.i0.r.i3.pos=3&rs.i1.r.i4.hold=false&freespins.left=15&rs.i0.r.i4.pos=20&rs.i1.r.i2.attention.i0=2&rs.i1.r.i0.attention.i0=1&rs.i1.r.i3.attention.i0=1&nextaction=freespin&wavecount=1&rs.i0.r.i2.syms=SYM3%2CSYM3%2CSYM3&rs.i1.r.i1.hold=false&rs.i0.r.i3.hold=false&game.win.amount=0.00&bet.denomination=2&freespins.totalwin.cents=0\n";
                            break;
                        case 'spin':
                            $linesId = [];
                            $linesId[0] = [
                                2, 
                                2, 
                                2, 
                                2, 
                                2
                            ];
                            $linesId[1] = [
                                1, 
                                1, 
                                1, 
                                1, 
                                1
                            ];
                            $linesId[2] = [
                                3, 
                                3, 
                                3, 
                                3, 
                                3
                            ];
                            $linesId[3] = [
                                1, 
                                2, 
                                3, 
                                2, 
                                1
                            ];
                            $linesId[4] = [
                                3, 
                                2, 
                                1, 
                                2, 
                                3
                            ];
                            $linesId[5] = [
                                1, 
                                1, 
                                2, 
                                1, 
                                1
                            ];
                            $linesId[6] = [
                                3, 
                                3, 
                                2, 
                                3, 
                                3
                            ];
                            $linesId[7] = [
                                2, 
                                3, 
                                3, 
                                3, 
                                2
                            ];
                            $linesId[8] = [
                                2, 
                                1, 
                                1, 
                                1, 
                                2
                            ];
                            $linesId[9] = [
                                2, 
                                1, 
                                2, 
                                1, 
                                2
                            ];
                            $lines = 10;
                            $slotSettings->CurrentDenom = $postData['bet_denomination'];
                            $slotSettings->CurrentDenomination = $postData['bet_denomination'];
                            if( $postData['slotEvent'] != 'freespin' ) 
                            {
                                $betline = $postData['bet_betlevel'];
                                $allbet = $betline * $lines;
                                $slotSettings->UpdateJackpots($allbet);
                                if( !isset($postData['slotEvent']) ) 
                                {
                                    $postData['slotEvent'] = 'bet';
                                }
                                $slotSettings->SetBalance(-1 * $allbet, $postData['slotEvent']);
                                $bankSum = $allbet / 100 * $slotSettings->GetPercent();
                                $slotSettings->SetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''), $bankSum, $postData['slotEvent']);
                                $slotSettings->UpdateJackpots($allbet);
                                $slotSettings->SetGameData('StarBurstNETBonusWin', 0);
                                $slotSettings->SetGameData('StarBurstNETFreeGames', 0);
                                $slotSettings->SetGameData('StarBurstNETCurrentFreeGame', 0);
                                $slotSettings->SetGameData('StarBurstNETTotalWin', 0);
                                $slotSettings->SetGameData('StarBurstNETBet', $betline);
                                $slotSettings->SetGameData('StarBurstNETDenom', $postData['bet_denomination']);
                                $slotSettings->SetGameData('StarBurstNETFreeBalance', sprintf('%01.2f', $slotSettings->GetBalance()) * 100);
                                $slotSettings->SetGameData('StarBurstNETHolds', [
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0
                                ]);
                                $bonusMpl = 1;
                            }
                            else
                            {
                                $postData['bet_denomination'] = $slotSettings->GetGameData('StarBurstNETDenom');
                                $slotSettings->CurrentDenom = $postData['bet_denomination'];
                                $slotSettings->CurrentDenomination = $postData['bet_denomination'];
                                $betline = $slotSettings->GetGameData('StarBurstNETBet');
                                $allbet = $betline * $lines;
                                $slotSettings->SetGameData('StarBurstNETCurrentFreeGame', $slotSettings->GetGameData('StarBurstNETCurrentFreeGame') + 1);
                                $bonusMpl = $slotSettings->slotFreeMpl;
                            }
                            $winTypeTmp = $slotSettings->GetSpinSettings($postData['slotEvent'], $allbet, $lines);
                            $winType = $winTypeTmp[0];
                            $spinWinLimit = $winTypeTmp[1];
                            /*if( !$slotSettings->HasGameDataStatic($slotSettings->slotId . 'timeWinLimit') || $slotSettings->GetGameDataStatic($slotSettings->slotId . 'timeWinLimit') <= 0 ) 
                            {
                                $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWinLimitNum', rand(0, count($slotSettings->winLimitsArr) - 1));
                                $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWinLimit0', time());
                                $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWinLimit', $slotSettings->winLimitsArr[$slotSettings->GetGameDataStatic($slotSettings->slotId . 'timeWinLimitNum')][0]);
                                $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWin', 0);
                            }*/
                            $balanceInCents = round($slotSettings->GetBalance() * $slotSettings->CurrentDenom * 100);
                            if( $winType == 'bonus' && $postData['slotEvent'] == 'freespin' ) 
                            {
                                $winType = 'win';
                            }
                            $jackRandom = rand(1, 500);
                            $mainSymAnim = '';
                            for( $i = 0; $i <= 2000; $i++ ) 
                            {
                                $totalWin = 0;
                                $lineWins = [];
                                $cWins = [
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0, 
                                    0
                                ];
                                $wild = ['1'];
                                $scatter = '';
                                $reels = $slotSettings->GetReelStrips($winType, $postData['slotEvent']);
                                $tmpReels = $reels;
                                $holds = $slotSettings->GetGameData('StarBurstNETHolds');
                                for( $r = 1; $r <= 5; $r++ ) 
                                {
                                    if( $postData['slotEvent'] == 'freespin' && $holds[$r - 1] == 1 ) 
                                    {
                                        $reels['reel' . $r][0] = '1';
                                        $reels['reel' . $r][1] = '1';
                                        $reels['reel' . $r][2] = '1';
                                        break;
                                    }
                                    for( $p = 0; $p <= 2; $p++ ) 
                                    {
                                        if( $reels['reel' . $r][$p] == '1' ) 
                                        {
                                            $reels['reel' . $r][0] = '1';
                                            $reels['reel' . $r][1] = '1';
                                            $reels['reel' . $r][2] = '1';
                                            break;
                                        }
                                    }
                                }
                                $winLineCount = 0;
                                for( $k = 0; $k < $lines; $k++ ) 
                                {
                                    $tmpStringWin = '';
                                    for( $j = 0; $j < count($slotSettings->SymbolGame); $j++ ) 
                                    {
                                        $csym = (string)$slotSettings->SymbolGame[$j];
                                        if( $csym == $scatter || !isset($slotSettings->Paytable['SYM_' . $csym]) ) 
                                        {
                                        }
                                        else
                                        {
                                            $s = [];
                                            $s[0] = $reels['reel1'][$linesId[$k][0] - 1];
                                            $s[1] = $reels['reel2'][$linesId[$k][1] - 1];
                                            $s[2] = $reels['reel3'][$linesId[$k][2] - 1];
                                            $s[3] = $reels['reel4'][$linesId[$k][3] - 1];
                                            $s[4] = $reels['reel5'][$linesId[$k][4] - 1];
                                            if( ($s[0] == $csym || in_array($s[0], $wild)) && ($s[1] == $csym || in_array($s[1], $wild)) && ($s[2] == $csym || in_array($s[2], $wild)) ) 
                                            {
                                                $mpl = 1;
                                                if( in_array($s[0], $wild) && in_array($s[1], $wild) && in_array($s[2], $wild) ) 
                                                {
                                                    $mpl = 1;
                                                }
                                                else if( in_array($s[0], $wild) || in_array($s[1], $wild) || in_array($s[2], $wild) ) 
                                                {
                                                    $mpl = $slotSettings->slotWildMpl;
                                                }
                                                $tmpWin = $slotSettings->Paytable['SYM_' . $csym][3] * $betline * $mpl * $bonusMpl;
                                                if( $cWins[$k] < $tmpWin ) 
                                                {
                                                    $cWins[$k] = $tmpWin;
                                                    $tmpStringWin = '&ws.i' . $winLineCount . '.reelset=basic&ws.i' . $winLineCount . '.types.i0.coins=' . $tmpWin . '&ws.i' . $winLineCount . '.pos.i0=0%2C' . ($linesId[$k][0] - 1) . '&ws.i' . $winLineCount . '.pos.i1=1%2C' . ($linesId[$k][1] - 1) . '&ws.i' . $winLineCount . '.pos.i2=2%2C' . ($linesId[$k][2] - 1) . '&ws.i' . $winLineCount . '.types.i0.wintype=coins&ws.i' . $winLineCount . '.betline=' . $k . '&ws.i' . $winLineCount . '.sym=SYM' . $csym . '&ws.i' . $winLineCount . '.direction=left_to_right&ws.i' . $winLineCount . '.types.i0.cents=' . ($tmpWin * $slotSettings->CurrentDenomination * 100) . '';
                                                    $mainSymAnim = $csym;
                                                }
                                            }
                                            if( ($s[0] == $csym || in_array($s[0], $wild)) && ($s[1] == $csym || in_array($s[1], $wild)) && ($s[2] == $csym || in_array($s[2], $wild)) && ($s[3] == $csym || in_array($s[3], $wild)) ) 
                                            {
                                                $mpl = 1;
                                                if( in_array($s[0], $wild) && in_array($s[1], $wild) && in_array($s[2], $wild) && in_array($s[3], $wild) ) 
                                                {
                                                    $mpl = 1;
                                                }
                                                else if( in_array($s[0], $wild) || in_array($s[1], $wild) || in_array($s[2], $wild) || in_array($s[3], $wild) ) 
                                                {
                                                    $mpl = $slotSettings->slotWildMpl;
                                                }
                                                $tmpWin = $slotSettings->Paytable['SYM_' . $csym][4] * $betline * $mpl * $bonusMpl;
                                                if( $cWins[$k] < $tmpWin ) 
                                                {
                                                    $cWins[$k] = $tmpWin;
                                                    $tmpStringWin = '&ws.i' . $winLineCount . '.reelset=basic&ws.i' . $winLineCount . '.types.i0.coins=' . $tmpWin . '&ws.i' . $winLineCount . '.pos.i0=0%2C' . ($linesId[$k][0] - 1) . '&ws.i' . $winLineCount . '.pos.i1=1%2C' . ($linesId[$k][1] - 1) . '&ws.i' . $winLineCount . '.pos.i2=2%2C' . ($linesId[$k][2] - 1) . '&ws.i' . $winLineCount . '.pos.i3=3%2C' . ($linesId[$k][3] - 1) . '&ws.i' . $winLineCount . '.types.i0.wintype=coins&ws.i' . $winLineCount . '.betline=' . $k . '&ws.i' . $winLineCount . '.sym=SYM' . $csym . '&ws.i' . $winLineCount . '.direction=left_to_right&ws.i' . $winLineCount . '.types.i0.cents=' . ($tmpWin * $slotSettings->CurrentDenomination * 100) . '';
                                                    $mainSymAnim = $csym;
                                                }
                                            }
                                            if( ($s[0] == $csym || in_array($s[0], $wild)) && ($s[1] == $csym || in_array($s[1], $wild)) && ($s[2] == $csym || in_array($s[2], $wild)) && ($s[3] == $csym || in_array($s[3], $wild)) && ($s[4] == $csym || in_array($s[4], $wild)) ) 
                                            {
                                                $mpl = 1;
                                                if( in_array($s[0], $wild) && in_array($s[1], $wild) && in_array($s[2], $wild) && in_array($s[3], $wild) && in_array($s[4], $wild) ) 
                                                {
                                                    $mpl = 1;
                                                }
                                                else if( in_array($s[0], $wild) || in_array($s[1], $wild) || in_array($s[2], $wild) || in_array($s[3], $wild) || in_array($s[4], $wild) ) 
                                                {
                                                    $mpl = $slotSettings->slotWildMpl;
                                                }
                                                $tmpWin = $slotSettings->Paytable['SYM_' . $csym][5] * $betline * $mpl * $bonusMpl;
                                                if( $cWins[$k] < $tmpWin ) 
                                                {
                                                    $cWins[$k] = $tmpWin;
                                                    $tmpStringWin = '&ws.i' . $winLineCount . '.reelset=basic&ws.i' . $winLineCount . '.types.i0.coins=' . $tmpWin . '&ws.i' . $winLineCount . '.pos.i0=0%2C' . ($linesId[$k][0] - 1) . '&ws.i' . $winLineCount . '.pos.i1=1%2C' . ($linesId[$k][1] - 1) . '&ws.i' . $winLineCount . '.pos.i2=2%2C' . ($linesId[$k][2] - 1) . '&ws.i' . $winLineCount . '.pos.i3=3%2C' . ($linesId[$k][3] - 1) . '&ws.i' . $winLineCount . '.pos.i4=4%2C' . ($linesId[$k][4] - 1) . '&ws.i' . $winLineCount . '.types.i0.wintype=coins&ws.i' . $winLineCount . '.betline=' . $k . '&ws.i' . $winLineCount . '.sym=SYM' . $csym . '&ws.i' . $winLineCount . '.direction=left_to_right&ws.i' . $winLineCount . '.types.i0.cents=' . ($tmpWin * $slotSettings->CurrentDenomination * 100) . '';
                                                    $mainSymAnim = $csym;
                                                }
                                            }
                                        }
                                    }
                                    if( $cWins[$k] > 0 && $tmpStringWin != '' ) 
                                    {
                                        array_push($lineWins, $tmpStringWin);
                                        $totalWin += $cWins[$k];
                                        $winLineCount++;
                                    }
                                }
                                $holdReels = [
                                    '&rs.i0.r.i0.hold=false', 
                                    '&rs.i0.r.i1.hold=false', 
                                    '&rs.i0.r.i2.hold=false', 
                                    '&rs.i0.r.i3.hold=false', 
                                    '&rs.i0.r.i4.hold=false'
                                ];
                                $scattersWin = 0;
                                $scattersStr = '';
                                $scattersCount = 0;
                                $scPos = [];
                                for( $r = 1; $r <= 5; $r++ ) 
                                {
                                    for( $p = 0; $p <= 2; $p++ ) 
                                    {
                                        if( $reels['reel' . $r][$p] == '1' && $postData['slotEvent'] != 'freespin' ) 
                                        {
                                            $scattersCount++;
                                            $holdReels[$r - 1] = '&rs.i0.r.i' . ($r - 1) . '.hold=true';
                                            $holds[$r - 1] = 1;
                                        }
                                    }
                                }
                                if( $scattersCount >= 1 ) 
                                {
                                }
                                $slotSettings->SetGameData('StarBurstNETHolds', $holds);
                                $totalWin += $scattersWin;
                                if( $i > 1000 ) 
                                {
                                    $winType = 'none';
                                }
                                if( $i > 1500 ) 
                                {
                                    $response = '{"responseEvent":"error","responseType":"' . $postData['slotEvent'] . '","serverResponse":"Bad Reel Strip"}';
                                    exit( $response );
                                }
                                    if( $slotSettings->MaxWin < ($totalWin * $slotSettings->CurrentDenom) ) 
                                    {
                                    }
                                else
                                {
                                    $minWin = $slotSettings->GetRandomPay();
                                    if( $i > 700 ) 
                                    {
                                        $minWin = 0;
                                    }
                                    if( $slotSettings->increaseRTP && $winType == 'win' && $totalWin < ($minWin * $allbet) ) 
                                    {
                                    }
                                    else if( $scattersCount >= 1 && $winType != 'bonus' ) 
                                    {
                                    }
                                    else if( $totalWin <= $spinWinLimit && $winType == 'bonus' ) 
                                    {
                                        $cBank = $slotSettings->GetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''));
                                        if( $cBank < $spinWinLimit ) 
                                        {
                                            $spinWinLimit = $cBank;
                                        }
                                        else
                                        {
                                            break;
                                        }
                                    }
                                    else if( $totalWin > 0 && $totalWin <= $spinWinLimit && $winType == 'win' ) 
                                    {
                                        $cBank = $slotSettings->GetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''));
                                        if( $cBank < $spinWinLimit ) 
                                        {
                                            $spinWinLimit = $cBank;
                                        }
                                        else
                                        {
                                            break;
                                        }
                                    }
                                    else if( $totalWin == 0 && $winType == 'none' ) 
                                    {
                                        break;
                                    }
                                }
                            }
                            $freeState = '';
                            if( $totalWin > 0 ) 
                            {
                                $slotSettings->SetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''), -1 * $totalWin);
                                $slotSettings->SetBalance($totalWin);
                            }
                            $reportWin = $totalWin;
                            if( $postData['slotEvent'] == 'freespin' ) 
                            {
                                $slotSettings->SetGameData('StarBurstNETBonusWin', $slotSettings->GetGameData('StarBurstNETBonusWin') + $totalWin);
                                $slotSettings->SetGameData('StarBurstNETTotalWin', $slotSettings->GetGameData('StarBurstNETTotalWin') + $totalWin);
                            }
                            else
                            {
                                $slotSettings->SetGameData('StarBurstNETTotalWin', $totalWin);
                                $reels = $tmpReels;
                            }
                            $curReels = '&rs.i0.r.i0.syms=SYM' . $reels['reel1'][0] . '%2CSYM' . $reels['reel1'][1] . '%2CSYM' . $reels['reel1'][2] . '';
                            $curReels .= ('&rs.i0.r.i1.syms=SYM' . $reels['reel2'][0] . '%2CSYM' . $reels['reel2'][1] . '%2CSYM' . $reels['reel2'][2] . '');
                            $curReels .= ('&rs.i0.r.i2.syms=SYM' . $reels['reel3'][0] . '%2CSYM' . $reels['reel3'][1] . '%2CSYM' . $reels['reel3'][2] . '');
                            $curReels .= ('&rs.i0.r.i3.syms=SYM' . $reels['reel4'][0] . '%2CSYM' . $reels['reel4'][1] . '%2CSYM' . $reels['reel4'][2] . '');
                            $curReels .= ('&rs.i0.r.i4.syms=SYM' . $reels['reel5'][0] . '%2CSYM' . $reels['reel5'][1] . '%2CSYM' . $reels['reel5'][2] . '');
                            $fs = 0;
                            $nextaction = 'spin';
                            if( $scattersCount >= 1 ) 
                            {
                                $slotSettings->SetGameData('StarBurstNETFreeStartWin', $totalWin);
                                $slotSettings->SetGameData('StarBurstNETBonusWin', $totalWin);
                                $slotSettings->SetGameData('StarBurstNETFreeGames', 1);
                                $fs = $slotSettings->GetGameData('StarBurstNETFreeGames');
                                $nextaction = 'respin';
                            }
                            /*$newTime = time() - $slotSettings->GetGameDataStatic($slotSettings->slotId . 'timeWinLimit0');
                            $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWinLimit0', time());
                            $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWinLimit', $slotSettings->GetGameDataStatic($slotSettings->slotId . 'timeWinLimit') - $newTime);
                            $slotSettings->SetGameDataStatic($slotSettings->slotId . 'timeWin', $slotSettings->GetGameDataStatic($slotSettings->slotId . 'timeWin') + ($totalWin * $slotSettings->CurrentDenom));*/
                            $winString = implode('', $lineWins);
                            $jsSpin = '' . json_encode($reels) . '';
                            $jsJack = '' . json_encode($slotSettings->Jackpots) . '';
                            $winstring = '';
                            $slotSettings->SetGameData('StarBurstNETGambleStep', 5);
                            $hist = $slotSettings->GetGameData('StarBurstNETCards');
                            $isJack = 'false';
                            $gameover = 'true';
                            if( $postData['slotEvent'] == 'freespin' ) 
                            {
                                $totalWin = $slotSettings->GetGameData('StarBurstNETBonusWin');
                                $stack = 'basic';
                                $gamestate = 'basic';
                                $fs = $slotSettings->GetGameData('StarBurstNETFreeGames');
                                $fsl = $slotSettings->GetGameData('StarBurstNETFreeGames') - $slotSettings->GetGameData('StarBurstNETCurrentFreeGame');
                                $result_tmp[] = '&previous.rs.i0=wildOnReel_2&rs.i0.r.i2.overlay.i2.pos=2&g4mode=false&playercurrency=%26%23x20AC%3B&historybutton=false&current.rs.i0=basic&rs.i0.r.i4.hold=false&rs.i0.r.i2.overlay.i1.pos=1&next.rs=basic&gamestate.history=basic&rs.i0.r.i1.syms=SYM6%2CSYM6%2CSYM8&game.win.cents=5000&rs.i0.r.i2.overlay.i0.pos=0&rs.i0.id=wildOnReel_2&totalwin.coins=50&credit=303000&gamestate.current=basic&rs.i0.r.i2.overlay.i0.row=0&jackpotcurrency=%26%23x20AC%3B&multiplier=1&last.rs=wildOnReel_2&rs.i0.r.i0.syms=SYM8%2CSYM8%2CSYM7&rs.i0.r.i3.syms=SYM6%2CSYM6%2CSYM7&rs.i0.r.i2.overlay.i0.with=SYM1&rs.i0.r.i2.overlay.i1.row=1&isJackpotWin=false&gamestate.stack=basic&rs.i0.r.i0.pos=46&gamesoundurl=&rs.i0.r.i2.overlay.i2.row=2&rs.i0.r.i1.pos=288&game.win.coins=50&playercurrencyiso=' . $slotSettings->slotCurrency . '&rs.i0.r.i1.hold=false&playforfun=false&jackpotcurrencyiso=' . $slotSettings->slotCurrency . '&clientaction=respin&rs.i0.r.i2.hold=false&rs.i0.r.i4.syms=SYM5%2CSYM5%2CSYM5&rs.i0.r.i2.pos=0&totalwin.cents=5000&gameover=true&rs.i0.r.i0.hold=false&rs.i0.r.i3.pos=137&rs.i0.r.i4.pos=27&nextaction=spin&wavecount=1&rs.i0.r.i2.syms=SYM1%2CSYM1%2CSYM1&rs.i0.r.i3.hold=false&game.win.amount=50' . '&game.win.coins=' . $totalWin . '&game.win.cents=' . ($totalWin * $slotSettings->CurrentDenomination * 100) . '&totalwin.coins=' . $totalWin . '&credit=' . $balanceInCents . '&totalwin.cents=' . ($totalWin * $slotSettings->CurrentDenomination * 100) . '&game.win.amount=' . ($totalWin / $slotSettings->CurrentDenomination) . $curReels . $winString . implode('', $holdReels);
                            }
                            else
                            {
                                $result_tmp[] = 'rs.i0.r.i1.pos=18&g4mode=false&game.win.coins=' . $totalWin . '&playercurrency=%26%23x20AC%3B&playercurrencyiso=' . $slotSettings->slotCurrency . '&historybutton=false&rs.i0.r.i1.hold=false&rs.i0.r.i4.hold=false&gamestate.history=basic&playforfun=false&jackpotcurrencyiso=' . $slotSettings->slotCurrency . '&clientaction=' . $nextaction . '&rs.i0.r.i2.hold=false&game.win.cents=' . ($totalWin * $slotSettings->CurrentDenomination * 100) . '&rs.i0.r.i2.pos=47&rs.i0.id=basic&totalwin.coins=' . $totalWin . '&credit=' . $balanceInCents . '&totalwin.cents=' . ($totalWin * $slotSettings->CurrentDenomination * 100) . '&gamestate.current=basic&gameover=true&rs.i0.r.i0.hold=false&last.rs=basic&jackpotcurrency=%26%23x20AC%3B&multiplier=1&rs.i0.r.i3.pos=4&rs.i0.r.i4.pos=5&isJackpotWin=false&gamestate.stack=basic&nextaction=' . $nextaction . '&rs.i0.r.i0.pos=7&wavecount=1&gamesoundurl=&rs.i0.r.i3.hold=false&game.win.amount=' . ($totalWin / $slotSettings->CurrentDenomination) . '' . $curReels . $winString . implode('', $holdReels);
                            }
                            $response = '{"responseEvent":"spin","responseType":"' . $postData['slotEvent'] . '","serverResponse":{"freeState":"' . $freeState . '","slotLines":' . $lines . ',"slotBet":' . $betline . ',"totalFreeGames":' . $slotSettings->GetGameData('StarBurstNETFreeGames') . ',"currentFreeGames":' . $slotSettings->GetGameData('StarBurstNETCurrentFreeGame') . ',"Balance":' . $balanceInCents . ',"afterBalance":' . $balanceInCents . ',"bonusWin":' . $slotSettings->GetGameData('StarBurstNETBonusWin') . ',"totalWin":' . $totalWin . ',"winLines":[],"Jackpots":' . $jsJack . ',"reelsSymbols":' . $jsSpin . '}}';
                            $slotSettings->SaveLogReport($response, $allbet, $lines, $reportWin, $postData['slotEvent']);
                            $balanceInCents = round($slotSettings->GetBalance() * $slotSettings->CurrentDenom * 100);
                            break;
                    }
                    $response = $result_tmp[0];
                    $slotSettings->SaveGameData();
                    $slotSettings->SaveGameDataStatic();
                    echo $response;
                }
                catch( \Exception $e ) 
                {
                    if( isset($slotSettings) ) 
                    {
                        $slotSettings->InternalErrorSilent($e);
                    }
                    else
                    {
                            $strLog = '';
                            $strLog .= "\n";
                            $strLog .= ('{"responseEvent":"error","responseType":"' . $e . '","serverResponse":"InternalError","request":' . json_encode($_REQUEST) . ',"requestRaw":' . file_get_contents('php://input') . '}');
                            $strLog .= "\n";
                            $strLog .= ' ############################################### ';
                            $strLog .= "\n";
                            $slg = '';
                        if( file_exists(storage_path('logs/') . 'GameInternal.log') ) 
                        {
                            $slg = file_get_contents(storage_path('logs/') . 'GameInternal.log');
                        }
                        file_put_contents(storage_path('logs/') . 'GameInternal.log', $slg . $strLog);
                    }
                }
        }, 5);
    }
    get_($request, $game);
	
    }
  }
}
