<?php $__env->startSection('page-title', __('app.sms_mailings')); ?>
<?php $__env->startSection('page-heading', __('app.sms_mailings')); ?>

<?php $__env->startSection('content'); ?>

	<section class="content-header">
		<?php echo $__env->make('backend.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	</section>

	<section class="content">
		<div class="box box-danger collapsed-box sms_mailings_show">
			<div class="box-header with-border">
				<h3 class="box-title"><?php echo app('translator')->get('app.filter'); ?></h3>
				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
				</div>
			</div>
			<div class="box-body">

				<form action="" method="GET" id="users-form" >
					<div class="row">
						<div class="col-md-6">
							<label><?php echo app('translator')->get('app.theme'); ?></label>
							<input type="text" class="form-control" name="theme" value="<?php echo e(Request::get('theme')); ?>" placeholder="">
						</div>
						<div class="col-md-6">
							<label><?php echo app('translator')->get('app.date_start'); ?></label>
							<div class="input-group date">
								<div class="input-group-addon">
									<i class="fa fa-calendar"></i>
								</div>
								<input type="text" name="date_start" class="form-control pull-right datepicker" value="<?php echo e(Request::get('date_start')); ?>">
							</div>
						</div>
					</div>
					<br>
					<div class="row">
						<div class="col-md-12">
							<button type="submit" class="btn btn-primary">
								<?php echo app('translator')->get('app.filter'); ?>
							</button>
						</div>
					</div>
				</form>
			</div>
		</div>

		<div class="box box-primary">
			<div class="box-header with-border">
				<h3 class="box-title"><?php echo app('translator')->get('app.sms_mailings'); ?></h3>
				<div class="pull-right box-tools">
					<a href="<?php echo e(route('backend.sms_mailing.create')); ?>" class="btn btn-block btn-primary btn-sm"><?php echo app('translator')->get('app.add'); ?></a>
				</div>
			</div>
			<div class="box-body">
				<div class="table-responsive">
					<table class="table table-bordered table-striped">
						<thead>
						<tr>
							<th><?php echo app('translator')->get('app.id'); ?></th>
							<th><?php echo app('translator')->get('app.theme'); ?></th>
							<th><?php echo app('translator')->get('app.roles'); ?></th>
							<th><?php echo app('translator')->get('app.user_statuses'); ?></th>
							<th><?php echo app('translator')->get('app.date_start'); ?></th>
							<th><?php echo app('translator')->get('app.messages'); ?></th>
							<th><?php echo app('translator')->get('app.status'); ?></th>
						</tr>
						</thead>
						<tbody>
						<?php if(count($mailings)): ?>
							<?php $__currentLoopData = $mailings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mailing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php echo $__env->make('backend.sms_mailings.partials.row', ['base' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php else: ?>
							<tr><td colspan="9"><?php echo app('translator')->get('app.no_records_found'); ?></td></tr>
						<?php endif; ?>
						</tbody>
						<thead>
						<tr>
							<th>ID</th>
							<th>Theme</th>
							<th>Roles</th>
							<th>User Statuses</th>
							<th>Date Start</th>
							<th>Messages</th>
							<th>Status</th>
						</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>


		$('.datepicker').daterangepicker({
			"locale": {
				format: 'YYYY-MM-DD'
			},
			"startDate": "<?php echo e(date('Y-m-d')); ?>",
			"endDate": "<?php echo e(date('Y-m-d', time() + 31*24*60*60)); ?>"
		});

		$('.btn-box-tool').click(function(event){
			if( $('.sms_mailings_show').hasClass('collapsed-box') ){
				$.cookie('sms_mailings_show', '1');
			} else {
				$.removeCookie('sms_mailings_show');
			}
		});

		if( $.cookie('sms_mailings_show') ){
			$('.sms_mailings_show').removeClass('collapsed-box');
			$('.sms_mailings_show .btn-box-tool i').removeClass('fa-plus').addClass('fa-minus');
		}

	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\localhost\resources\views/backend/sms_mailings/list.blade.php ENDPATH**/ ?>