<?php $__env->startSection('page-title', $role->name .' '. trans('app.tree')); ?>
<?php $__env->startSection('page-heading', $role->name .' '. trans('app.tree')); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <?php echo $__env->make('backend.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>

    <section class="content">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><?php echo e($role->name); ?> <?php echo app('translator')->get('app.tree'); ?></h3>
            </div>
            <div class="box-body">
                <div class="table-responsive">

                    <table class="table table-bordered">
                        <thead>
                        <tr>
                            <?php if( auth()->user()->hasRole(['admin','agent']) ): ?>
                                <th><?php echo app('translator')->get('app.agent'); ?></th>
                            <?php endif; ?>
                            <th><?php echo app('translator')->get('app.distributor'); ?></th>
                            <th><?php echo app('translator')->get('app.shop'); ?></th>
                            <th><?php echo app('translator')->get('app.manager'); ?></th>
                            <th><?php echo app('translator')->get('app.cashier'); ?></th>
                            <th><?php echo app('translator')->get('app.user'); ?></th>
                        </tr>
                        </thead>
                        <tbody>

                        <tr>
                        <?php if( auth()->user()->hasRole(['admin','agent']) ): ?>
                            <?php if( isset($tree['agents']) && count($tree['agents']) ): ?>
                                <?php $__currentLoopData = $tree['agents']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent_id=>$agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td rowspan="<?php echo e($agent['rowspan']); ?>">
                                        <a href="<?php echo e($agent['href']); ?>">
                                            <?php echo e($agent['text']); ?>

                                        </a>
                                        <?php if( isset($agent['balance']) ): ?>
                                            <p><?php echo app('translator')->get('app.balance'); ?>: <?php echo e(number_format($agent['balance'], 2, '.', '')); ?></p>
                                        <?php endif; ?>
                                    </td>

                                    <?php if( count($agent['distributors']) ): ?>
                                        <?php $__currentLoopData = $agent['distributors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $distributor_id=>$distributor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo $__env->make('backend.user.partials.distributor2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <td colspan="5"></td></tr><tr></tr><tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <td colspan="6"><?php echo app('translator')->get('app.no_data'); ?></td>
                            <?php endif; ?>
                        <?php endif; ?>

                            <?php if( auth()->user()->hasRole(['distributor']) ): ?>
                                <?php echo $__env->make('backend.user.partials.distributor2', ['distributor' => $tree['distributor']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </tr>

                        </tbody>
                        <thead>
                        <tr>
                            <?php if( auth()->user()->hasRole(['admin','agent']) ): ?>
                                <th><?php echo app('translator')->get('app.agent'); ?></th>
                            <?php endif; ?>
                            <th><?php echo app('translator')->get('app.distributor'); ?></th>
                            <th><?php echo app('translator')->get('app.shop'); ?></th>
                            <th><?php echo app('translator')->get('app.manager'); ?></th>
                            <th><?php echo app('translator')->get('app.cashier'); ?></th>
                            <th><?php echo app('translator')->get('app.user'); ?></th>
                        </tr>
                        </thead>
                    </table>




                </div>
            </div>
        </div>
    </section>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\localhost\resources\views/backend/user/tree.blade.php ENDPATH**/ ?>