<?php $__env->startSection('page-title', 'Progress'); ?>

<?php $__env->startSection('add-main-class', 'main-pt'); ?>

<?php $__env->startSection('content'); ?>


	<?php
        if(Auth::check()){
            $currency = auth()->user()->present()->shop ? auth()->user()->present()->shop->currency : '';
        } else{
            $currency = '';
        }
	?>

    <?php echo $__env->make('frontend.Default.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="progress">
        <div class="container">
            <h1 class="progress__title"><span class="accent">PROGRESS</span> PROGRAM</h1>
            <p class="progress__subtitle">Play, Level Up, Get Rewards!</p>
            <p class="progress__text">
                When playing slots, you’ll accumulate points and guarantee yourself increasingly larger rewards for opening new statuses. These rewards are an addition to your in-game wins. To see all the rewards available, check out the table below. Here we go!
            </p>
            <div class="progress__block">

                <?php if($progress && count($progress)): ?>
                <?php $__currentLoopData = $progress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="progress__item <?php if(auth()->user()->rating == $item->rating): ?> active <?php endif; ?>">
                        <div class="progress__icon">
                            <?php $badge = strlen($item->rating) == 1 ? '0'  . $item->rating : $item->rating; ?>
                            <img src="/frontend/Default/img/badges128x128/badge-<?php echo e($badge); ?>.png" alt="">
                        </div>
                        <div class="progress__top">
                            <span class="progress__label level"><?php echo e($item->rating); ?> level</span>
                            <span class="progress__label cr"><?php echo e(number_format($item->bonus, 0,""," ")); ?> <?php echo e($currency); ?></span>
                        </div>
                        <ul class="progress__list">
                            <li class="progress__list-item">
                                <span>Money In</span>
                                <?php echo e(number_format($item->sum, 0,""," ")); ?>

                            </li>
                            <li class="progress__list-item">
                                <span>Type</span>
                                <?php echo e(__('app.' . $item->type)); ?>

                            </li>
                            <li class="progress__list-item">
                                <span>Bid Amount</span>
                                <?php echo e($item->spins); ?>

                            </li>
                            <li class="progress__list-item">
                                <span>Minimal Bet</span>
                                <?php echo e($item->bet); ?>

                            </li>
                        </ul>
                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

            </div>
        </div>
    </div>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
	<?php echo $__env->make('frontend.Default.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<?php echo $__env->make('frontend.Default.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.Default.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OpenServer\domains\bet\resources\views/frontend/Default/pages/progress.blade.php ENDPATH**/ ?>