<div class="grid-item grid-item--width2">
    <div class="grid__content games">
        <div class="games__item">
            <div class="games__content">
                <img class="lazy" src="/frontend/Default/img/_src/game_loader.png" data-src="<?php echo e($game->name ? '/frontend/Default/ico/' . $game->name . '.jpg' : ''); ?>" alt="<?php echo e($game->title); ?>">
                <?php if($game->jackpot): ?>
                    <span class="label label-d label--left">
					<?php echo e(number_format($game->jackpot->balance, 2,".","")); ?> <?php echo e($currency); ?>

					</span>
                <?php endif; ?>
                <?php if(
                    $game->tournaments->filter(function ($tournament){
                        return(
                            \Carbon\Carbon::now()->diffInSeconds(\Carbon\Carbon::parse($tournament->tournament->start), false) <= 0
                            &&
                            \Carbon\Carbon::now()->diffInSeconds(\Carbon\Carbon::parse($tournament->tournament->end), false) >= 0
                        );
                    })->count()
                ): ?>
                    <span class="label-cup">
						<span class="cup-img"><img src="/frontend/Default/img/svg/game-cup.svg" alt=""></span>
                        <?php if($game->is_new()): ?>
                            <span class="label"></span>
                            <span class="label label--right label-b ">NEW</span>
                        <?php elseif($game->is_hot()): ?>
                            <span class="label"></span>
                            <span class="label label--right label-g ">HOT</span>
                        <?php else: ?>
                            <?php if($game->label == 'Exclusive'): ?>
                                <span class="label"></span>
                                <span class="label label--right label-d"><?php echo e(mb_strtoupper($game->label)); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
					</span>
                <?php else: ?>

                    <?php if($game->is_new()): ?>
                        <span class="label"></span>
                        <span class="label label--right label-b ">NEW</span>
                    <?php elseif($game->is_hot()): ?>
                        <span class="label"></span>
                        <span class="label label--right label-g ">HOT</span>
                    <?php else: ?>
                        <?php if($game->label == 'Exclusive'): ?>
                            <span class="label"></span>
                            <span class="label label--right label-d"><?php echo e(mb_strtoupper($game->label)); ?></span>
                        <?php endif; ?>
                    <?php endif; ?>

                <?php endif; ?>
                <a href="<?php echo e(route('frontend.game.go', $game->name)); ?>?api_exit=/" class="play-btn checkAgreed btn">Play</a>
                <span class="game-name"><?php echo e($game->title); ?></span>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\OpenServer\domains\bet\resources\views/frontend/Default/partials/game.blade.php ENDPATH**/ ?>